/**
* \file: request_messages.c
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#include "ipc/request_messages.h"
#include "ipc/message_sendr.h"
#include "ipc/message_recvr.h"
#include "utils/automounter_types_internal.h"

//------------------------------------- public member definition ------------------------------------------------------
error_code_t request_message_prepare_remount_request_msg(message_buffer_t *msg_buffer, const char *identifier,
		const char *options, const identifier_type_t id_type, const int request_id, void *callback_func)
{
	error_code_t result;
	request_remount_message_t *msg_data;
	result=message_sendr_prepare_message(msg_buffer,REMOUNT_REQUEST_MSG,sizeof(request_remount_message_t),(void **)&msg_data);
	if (result==RESULT_OK)
	{
		msg_data->identifier=NULL;
		msg_data->options=NULL;
		msg_data->id_type=id_type;
		msg_data->request_id=request_id;
		msg_data->callback_func=callback_func;
		result=message_sendr_add_string_to_msg(msg_buffer,identifier);
	}

	if (result==RESULT_OK)
		result=message_sendr_add_string_to_msg(msg_buffer,options);

	return result;
}

error_code_t request_message_extract_remount_request_msg(message_buffer_t *msg_buffer,request_remount_message_t **msg_ptr)
{
	size_t data_size;
	if (message_recvr_get_msg_type(msg_buffer)!=REMOUNT_REQUEST_MSG)
		return RESULT_INVALID;

	message_recvr_get_msg_data(msg_buffer,(void **)msg_ptr, &data_size);
	if (data_size!=sizeof(request_remount_message_t))
		return RESULT_INVALID;

	(*msg_ptr)->identifier=message_recvr_get_first_msg_string(msg_buffer);
	(*msg_ptr)->options=message_recvr_get_next_msg_string(msg_buffer);
	if ((*msg_ptr)->identifier==NULL || (*msg_ptr)->options==NULL)
		return RESULT_INVALID;

	return RESULT_OK;
}

error_code_t request_message_prepare_umount_request_msg(message_buffer_t *msg_buffer, const char *identifier,
		const identifier_type_t id_type, const int request_id, void *callback_func)
{
	error_code_t result;
	request_umount_message_t *msg_data;
	result=message_sendr_prepare_message(msg_buffer,UMOUNT_REQUEST_MSG,sizeof(request_umount_message_t),(void **)&msg_data);
	if (result==RESULT_OK)
	{
		msg_data->identifier=NULL;
		msg_data->id_type=id_type;
		msg_data->request_id=request_id;
		msg_data->callback_func=callback_func;
		result=message_sendr_add_string_to_msg(msg_buffer,identifier);
	}

	return result;
}

error_code_t request_message_extract_umount_request_msg(message_buffer_t *msg_buffer,
		request_umount_message_t **msg_ptr)
{
	size_t data_size;
	if (message_recvr_get_msg_type(msg_buffer)!=UMOUNT_REQUEST_MSG)
		return RESULT_INVALID;

	message_recvr_get_msg_data(msg_buffer,(void **)msg_ptr, &data_size);
	if (data_size!=sizeof(request_umount_message_t))
		return RESULT_INVALID;

	(*msg_ptr)->identifier=message_recvr_get_first_msg_string(msg_buffer);
	if ((*msg_ptr)->identifier==NULL)
		return RESULT_INVALID;

	return RESULT_OK;
}

error_code_t request_message_prepare_request_done_msg(message_buffer_t *msg_buffer, error_code_t request_result,
		const char *error_msg, const int request_id, void *callback_func)
{
	error_code_t result;
	request_done_message_t *msg_data;
	result=message_sendr_prepare_message(msg_buffer,REQUEST_DONE_MSG,sizeof(request_done_message_t),(void **)&msg_data);
	if (result==RESULT_OK)
	{
		msg_data->result=request_result;
		msg_data->request_id=request_id;
		msg_data->callback_func=callback_func;

		//This is ok. When we are extracting the string, we are getting NULL back because there is no string
		//in the list
		if (error_msg!=NULL)
			result=message_sendr_add_string_to_msg(msg_buffer,error_msg);
	}

	return result;
}

error_code_t request_message_extract_request_done_msg(message_buffer_t *msg_buffer,
		request_done_message_t **msg_ptr)
{
	size_t data_size;
	if (message_recvr_get_msg_type(msg_buffer)!=REQUEST_DONE_MSG)
		return RESULT_INVALID;

	message_recvr_get_msg_data(msg_buffer,(void **)msg_ptr, &data_size);
	if (data_size!=sizeof(request_done_message_t))
		return RESULT_INVALID;

	(*msg_ptr)->error_message=message_recvr_get_first_msg_string(msg_buffer);
	//we don't have to check for NULL, if it is NULL, someone has passed NULL which results in not adding a string

	return RESULT_OK;
}
error_code_t request_message_prepare_snapshot_request_msg(message_buffer_t *msg_buffer, snapshot_scope_t scope,
		int request_id)
{
	error_code_t result;
	snapshot_request_message_t *msg_data;
	result=message_sendr_prepare_message(msg_buffer,GET_SNAPSHOT_MSG,sizeof(snapshot_request_message_t),(void **)&msg_data);
	if (result==RESULT_OK)
	{
		msg_data->scope=scope;
		msg_data->request_id=request_id;
	}
	return result;
}

error_code_t request_message_extract_snapshot_request_msg(message_buffer_t *msg_buffer,
		snapshot_request_message_t **msg_ptr)
{
	size_t data_size;

	if (message_recvr_get_msg_type(msg_buffer)!=GET_SNAPSHOT_MSG)
		return RESULT_INVALID;

	message_recvr_get_msg_data(msg_buffer,(void **)msg_ptr, &data_size);
	if (data_size!=sizeof(snapshot_request_message_t))
		return RESULT_INVALID;

	return RESULT_OK;
}

error_code_t request_message_prepare_snapshot_done_msg(message_buffer_t *msg_buffer, int request_id)
{
	error_code_t result;
	int *request_id_ptr;
	result=message_sendr_prepare_message(msg_buffer,SNAPSHOT_COMPLETE_MSG,sizeof(int),(void **)&request_id_ptr);
	if (result==RESULT_OK)
		*request_id_ptr=request_id;
	return result;
}

error_code_t request_message_extract_snapshot_done_msg(message_buffer_t *msg_buffer,
		int **request_id_ptr)
{
	size_t data_size;

	if (message_recvr_get_msg_type(msg_buffer)!=SNAPSHOT_COMPLETE_MSG)
		return RESULT_INVALID;

	message_recvr_get_msg_data(msg_buffer,(void **)request_id_ptr, &data_size);
	if (data_size!=sizeof(int))
		return RESULT_INVALID;

	return RESULT_OK;
}
//---------------------------------------------------------------------------------------------------------------------
